#include <BareBoneSim800.h>

BareBoneSim800 sim800; //
//BareBoneSim800 sim800("your APN");  //needed for gprs funtionality


int previousSMSIndex = 0;
int currentSMSIndex = 0;
String message = "";

#include <SPI.h>
#include <DMD2.h>
#include <fonts/SystemFont5x7.h>
#include <fonts/Arial14.h>

// Set Width to the number of displays wide you have
const int WIDTH = 1;

// You can change to a smaller font (two lines) by commenting this line,
// and uncommenting the line after it:
const uint8_t *FONT = Arial14;
//const uint8_t *FONT = SystemFont5x7;

SoftDMD dmd(WIDTH, 1); // DMD controls the entire display
DMD_TextBox box(dmd);  // "box" provides a text box to automatically write to/scroll the display


void setup() {
  Serial.begin(9600);
  sim800.begin();
  while (!Serial);

  Serial.println("Testing GSM module For New SMS Checking");
  delay(8000); // this delay is necessary, it helps the device to be ready and connect to a network

  Serial.println("Should be ready by now");
  bool deviceAttached = sim800.isAttached();
  if (deviceAttached)
    Serial.println("Device is Attached");
  else
    Serial.println("Not Attached");

  // Save the last sms
  currentSMSIndex = sim800.currentMessageIndex; //reads the last saved sms index
  previousSMSIndex = currentSMSIndex;

  Serial.println("Ready, Send your new SMS");
  
  dmd.setBrightness(255);
  dmd.selectFont(FONT);
  



}

void loop() {
  //zZZzz
bool checkSMS = sim800.checkNewSMS();
  if (checkSMS)
  {
    Serial.println("New SMS receieved");
    currentSMSIndex = sim800.currentMessageIndex;
    //lets read the sms
     message = sim800.readSMS(currentSMSIndex);
    Serial.print("Received message is: ");
    Serial.println(message);
    
    previousSMSIndex = currentSMSIndex; // update your sms index
    dmd.begin();
    box.println(message);
  }
  
  delay(5000);
}
